import { StarXpandCommand } from "star-io10-web";

export class LabelSample05_For203dpi_ShippingLabel2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 72.0),
              new StarXpandCommand.PageModeBuilder()
                .stylePrintDirection(
                  StarXpandCommand.Printer.PageModePrintDirection.BottomToTop,
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(
                    8.0,
                    50.0,
                  ).setY(24.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(4.0)
                    .actionPrintText("${business_name}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(8.0, 42.0)
                    .setX(10.0)
                    .setY(24.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleLineSpace(0.0)
                    .actionPrintText("${address}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(4.0, 42.0)
                    .setX(17.0)
                    .setY(24.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${telephone_number}\n",
                  ),
                )
                .actionPrintRuledLine(
                  new StarXpandCommand.Printer.PageModeRuledLineParameter(
                    0.0,
                    22.0,
                    72.0,
                    22.0,
                  )
                    .setLineStyle(StarXpandCommand.Printer.LineStyle.Single)
                    .setThickness(1.0),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "logo_01.png",
                    47.0,
                    0.0,
                    200,
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "shipping_label_house.png",
                    0.0,
                    10.0,
                    40,
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "shipping_label_phones_old.png",
                    0.0,
                    16.0,
                    40,
                  ),
                )
                .stylePrintDirection(
                  StarXpandCommand.Printer.PageModePrintDirection.LeftToRight,
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(47.0, 72.0)
                    .setX(25.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleBold(true)
                    .styleLineSpace(3.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(6.0)
                    .actionPrintText("TO:\n")
                    .styleBold(false)
                    .styleVerticalPositionBy(7.0)
                    .actionPrintText("${name_to}\n")
                    .styleVerticalPositionBy(3.0)
                    .actionPrintText("${address_to}\n"),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "business_name" : "BUSINESS NAME",
    "address" : "1234 MAIN AVENUE LONDON,\\nSW1A 1AA",
    "telephone_number" : "(111) 222 333",
    "name_to" : "John Smith",
    "address_to" : "123 HIGH STREET\\n\\nLONDON,\\n\\nSW1A 1AA"
}`,
    );
  }
}
